<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Audio_Quiz_Leaderboard;
use App\Models\Audio_Quiz_Question;
use App\Models\Category;
use App\Models\Classification;
use App\Models\General_Setting;
use App\Models\Notification;
use App\Models\Transaction;
use App\Models\Reward_Transaction;
use App\Models\Contest;
use Illuminate\Http\Request;
use App\Models\Common;
use App\Models\Contest_Leaderboard;
use App\Models\Contest_Question;
use App\Models\Contest_Transaction;
use App\Models\Daily_Quiz_Leaderboard;
use App\Models\Daily_Quiz_Question;
use App\Models\Exam;
use App\Models\Exam_Leaderboard;
use App\Models\Exam_Question;
use App\Models\Fear_Factor_Quiz_Leaderboard;
use App\Models\Fear_Factor_Quiz_Question;
use App\Models\Level;
use App\Models\Normal_Quiz_Leaderboard;
use App\Models\Normal_Quiz_Question;
use App\Models\Onboarding_Screen;
use App\Models\Package;
use App\Models\Page;
use App\Models\Payment_Option;
use App\Models\Pratice_Quiz_Leaderboard;
use App\Models\Pratice_Quiz_Question;
use App\Models\Product;
use App\Models\Product_Transaction;
use App\Models\Quiz_Configuration;
use App\Models\Read_Notification;
use App\Models\Refer_Earn;
use App\Models\Reward_Setting;
use App\Models\Skill;
use App\Models\Social_Link;
use App\Models\True_False_Quiz_Leaderboard;
use App\Models\True_False_Quiz_Question;
use App\Models\Ultimate_Challenge;
use App\Models\Ultimate_Challenge_Leaderboard;
use App\Models\Ultimate_Challenge_Question;
use App\Models\User;
use App\Models\Video_Quiz_Leaderboard;
use App\Models\Video_Quiz_Question;
use App\Models\Withdrawal_Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class HomeController extends Controller
{
    private $folder_setting = "setting";
    private $folder_package = "package";
    private $folder_notification = "notification";
    private $folder_category = "category";
    private $folder_skill = "skill";
    private $folder_classification = "classification";
    private $folder_level = "level";
    private $folder_question = "question";
    private $folder_ultimate_challenge = "ultimate_challenge";
    private $folder_exam = "exam";
    private $folder_contest = "contest";
    private $folder_product = "product";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function general_setting()
    {
        try {

            $list = General_Setting::get();
            foreach ($list as $key => $value) {
                if ($value['key'] == 'app_logo' || $value['key'] == 'company_logo') {
                    $value['value'] = $this->common->getImage($this->folder_setting, $value['value']);
                }
            }
            return $this->common->API_Response(200, __('api_msg.data_retrieved'), $list);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_payment_option()
    {
        try {

            $return['status'] = 200;
            $return['message'] = __('api_msg.data_retrieved');
            $return['result'] = [];

            $data = Payment_Option::get();
            foreach ($data as $key => $value) {
                $return['result'][$value['name']] = $value;
            }

            return $return;
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_pages()
    {
        try {
            $return['status'] = 200;
            $return['message'] = __('api_msg.data_retrieved');
            $return['result'] = [];

            $data = Page::where('status', 1)->get();
            for ($i = 0; $i < count($data); $i++) {
                $return['result'][$i]['title'] = $data[$i]['title'];
                $return['result'][$i]['url'] = route('page.view', $data[$i]['title']);
                $return['result'][$i]['icon'] = $this->common->getImage($this->folder_setting, $data[$i]['icon'], $data[$i]['storage_type']);
            }
            return $return;
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_social_link()
    {
        try {
            $data = Social_Link::get();
            if (sizeof($data) > 0) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_setting);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_onboarding_screen()
    {
        try {
            $data = Onboarding_Screen::get();
            if (sizeof($data) > 0) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_setting);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_quiz_configuration()
    {
        try {
            $data = Quiz_Configuration::where('status', 1)->get();
            if (sizeof($data) > 0) {
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_notification(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $arr = Read_Notification::where('user_id', $request['user_id'])->pluck('notification_id')->toArray();
            $data = Notification::whereNotIn('id', $arr)->latest()->get();

            $this->common->imageNameToUrl($data, 'image', $this->folder_notification);

            return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function read_notification(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'notification_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $noti = new Read_Notification();
            $noti['user_id'] = $request['user_id'];
            $noti['notification_id'] = $request['notification_id'];
            if ($noti->save()) {
                return $this->common->API_Response(200, __('api_msg.data_saved'), []);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_package()
    {
        try {

            $data = Package::orderBy('price', 'asc')->latest()->get();
            if ($data) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_package);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_category()
    {
        try {

            $data = Category::where('status', 1)->orderBy('sort_order', 'asc')->latest()->get();
            if ($data) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_category);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_skill()
    {
        try {

            $data = Skill::where('status', 1)->orderBy('sort_order', 'asc')->latest()->get();
            if ($data) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_skill);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_classification()
    {
        try {

            $data = Classification::where('status', 1)->orderBy('sort_order', 'asc')->latest()->get();
            if ($data) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_classification);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_level(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'quiz_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $quiz_id = $request['quiz_id'];
            $category_id = $request['category_id'] ?? 0;
            $skill_id = $request['skill_id'] ?? 0;
            $classification_id = $request['classification_id'] ?? 0;

            if ($quiz_id == 1) { // Pratice

                $data = Level::where('status', 1)->orderBy('sort_order', 'asc')->latest()->get();
                if ($data) {

                    foreach ($data as $key => $value) {

                        $value['image'] = $this->common->getImage($this->folder_level, $value['image']);
                        $value['is_pass_level'] = 1;
                    }
                    return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
                } else {
                    return $this->common->API_Response(400, __('api_msg.data_not_found'));
                }
            } else if (in_array($quiz_id, [2, 3, 4, 5, 6])) { // Normal || Audio || Video || True-False || Fear Factor

                $quiz = $this->common->get_quiz_config($quiz_id);
                if ($quiz) {

                    if ($quiz['joining_type'] == 1) {

                        $data = Level::where('status', 1)->orderBy('sort_order', 'asc')->latest()->get();
                        if ($data) {

                            foreach ($data as $key => $value) {

                                $value['image'] = $this->common->getImage($this->folder_level, $value['image']);
                                $value['is_pass_level'] = $this->common->is_pass_level($user_id, $quiz_id, $category_id, $skill_id, $classification_id, $value['id']);
                            }
                            return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
                        } else {
                            return $this->common->API_Response(400, __('api_msg.data_not_found'));
                        }
                    } else {

                        $data = Level::where('status', 1)->orderBy('sort_order', 'asc')->latest()->get();
                        if ($data) {

                            foreach ($data as $key => $value) {

                                $value['image'] = $this->common->getImage($this->folder_level, $value['image']);
                                $value['is_pass_level'] = 1;
                            }
                            return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
                        } else {
                            return $this->common->API_Response(400, __('api_msg.data_not_found'));
                        }
                    }
                } else {
                    return $this->common->API_Response(400, __('api_msg.data_not_found'));
                }
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_practice_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];

            $total_questions = $this->common->quiz_config_total_question(1);

            $data = Pratice_Quiz_Question::where('status', 1)
                ->when($category_id != 0, fn($q) => $q->where('category_id', $category_id))
                ->when($skill_id != 0, fn($q) => $q->where('skill_id', $skill_id))
                ->when($classification_id != 0, fn($q) => $q->where('classification_id', $classification_id))
                ->when($level_id != 0, fn($q) => $q->where('level_id', $level_id))
                ->inRandomOrder()->limit($total_questions)->get();

            if ($data) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_question);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_normal_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'joining_coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $joining_coin = $request['joining_coin'];

            $total_questions = $this->common->quiz_config_total_question(2);

            $data = Normal_Quiz_Question::where('status', 1)
                ->when($category_id != 0, fn($q) => $q->where('category_id', $category_id))
                ->when($skill_id != 0, fn($q) => $q->where('skill_id', $skill_id))
                ->when($classification_id != 0, fn($q) => $q->where('classification_id', $classification_id))
                ->when($level_id != 0, fn($q) => $q->where('level_id', $level_id))
                ->inRandomOrder()->limit($total_questions)->get();

            if ($data) {

                // Minus Coin
                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $joining_coin) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
                $user->decrement('wallet_coin', $joining_coin);

                $this->common->imageNameToUrl($data, 'image', $this->folder_question);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_audio_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'joining_coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $joining_coin = $request['joining_coin'];

            $total_questions = $this->common->quiz_config_total_question(3);

            $data = Audio_Quiz_Question::where('status', 1)
                ->when($category_id != 0, fn($q) => $q->where('category_id', $category_id))
                ->when($skill_id != 0, fn($q) => $q->where('skill_id', $skill_id))
                ->when($classification_id != 0, fn($q) => $q->where('classification_id', $classification_id))
                ->when($level_id != 0, fn($q) => $q->where('level_id', $level_id))
                ->inRandomOrder()->limit($total_questions)->get();

            if ($data) {

                // Minus Coin
                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $joining_coin) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
                $user->decrement('wallet_coin', $joining_coin);

                foreach ($data as $key => $value) {

                    $value['image'] = $this->common->getImage($this->folder_question, $value['image']);
                    if ($value['audio_type'] == 'server_audio') {
                        $value['audio'] = $this->common->getFile($this->folder_question, $value['audio']);
                    }
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_video_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'joining_coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $joining_coin = $request['joining_coin'];

            $total_questions = $this->common->quiz_config_total_question(4);

            $data = Video_Quiz_Question::where('status', 1)
                ->when($category_id != 0, fn($q) => $q->where('category_id', $category_id))
                ->when($skill_id != 0, fn($q) => $q->where('skill_id', $skill_id))
                ->when($classification_id != 0, fn($q) => $q->where('classification_id', $classification_id))
                ->when($level_id != 0, fn($q) => $q->where('level_id', $level_id))
                ->inRandomOrder()->limit($total_questions)->get();

            if ($data) {

                // Minus Coin
                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $joining_coin) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
                $user->decrement('wallet_coin', $joining_coin);

                foreach ($data as $key => $value) {

                    $value['image'] = $this->common->getImage($this->folder_question, $value['image']);
                    if ($value['video_type'] == 'server_video') {
                        $value['video'] = $this->common->getFile($this->folder_question, $value['video']);
                    }
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_true_false_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'joining_coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $joining_coin = $request['joining_coin'];

            $total_questions = $this->common->quiz_config_total_question(5);

            $data = True_False_Quiz_Question::where('status', 1)
                ->when($category_id != 0, fn($q) => $q->where('category_id', $category_id))
                ->when($skill_id != 0, fn($q) => $q->where('skill_id', $skill_id))
                ->when($classification_id != 0, fn($q) => $q->where('classification_id', $classification_id))
                ->when($level_id != 0, fn($q) => $q->where('level_id', $level_id))
                ->inRandomOrder()->limit($total_questions)->get();

            if ($data) {

                // Minus Coin
                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $joining_coin) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
                $user->decrement('wallet_coin', $joining_coin);

                $this->common->imageNameToUrl($data, 'image', $this->folder_question);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_fear_factor_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'joining_coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $joining_coin = $request['joining_coin'];

            $total_questions = $this->common->quiz_config_total_question(6);

            $data = Fear_Factor_Quiz_Question::where('status', 1)
                ->when($category_id != 0, fn($q) => $q->where('category_id', $category_id))
                ->when($skill_id != 0, fn($q) => $q->where('skill_id', $skill_id))
                ->when($classification_id != 0, fn($q) => $q->where('classification_id', $classification_id))
                ->when($level_id != 0, fn($q) => $q->where('level_id', $level_id))
                ->inRandomOrder()->limit($total_questions)->get();

            if ($data) {

                // Minus Coin
                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $joining_coin) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
                $user->decrement('wallet_coin', $joining_coin);

                $this->common->imageNameToUrl($data, 'image', $this->folder_question);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_daily_quiz_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'joining_coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $joining_coin = $request['joining_coin'];
            $today = date('Y-m-d');

            $played = Daily_Quiz_Leaderboard::where('user_id', $user_id)->whereDate('created_at', $today)->first();
            if ($played) {
                return $this->common->API_Response(400, __('api_msg.already_played_today'));
            }
            $total_questions = $this->common->quiz_config_total_question(9);

            $data = Daily_Quiz_Question::where('status', 1)->inRandomOrder()->limit($total_questions)->get();
            if ($data) {

                // Minus Coin
                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $joining_coin) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
                $user->decrement('wallet_coin', $joining_coin);

                $this->common->imageNameToUrl($data, 'image', $this->folder_question);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_practice_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $insert = new Pratice_Quiz_Leaderboard();
            $insert['user_id'] = $request['user_id'];
            $insert['category_id'] = $request['category_id'];
            $insert['skill_id'] = $request['skill_id'];
            $insert['classification_id'] = $request['classification_id'];
            $insert['level_id'] = $request['level_id'];
            $insert['total_questions'] = $request['total_questions'];
            $insert['questions_attended'] = $request['questions_attended'];
            $insert['correct_answers'] = $request['correct_answers'];
            $insert['percentage'] = ($request['questions_attended'] > 0)
                ? intval(round(($request['correct_answers'] / $request['total_questions']) * 100))
                : 0;

            $quiz_config = $this->common->Quiz_Configuration(1);
            if ($quiz_config['min_winning_percentage'] <= $insert['percentage']) {
                $insert['status'] = 1;
            } else {
                $insert['status'] = 0;
            }

            if ($insert->save()) {
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_normal_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];
            $quiz_config = $this->common->Quiz_Configuration(2);

            $insert = new Normal_Quiz_Leaderboard([
                'user_id' => $user_id,
                'category_id' => $category_id,
                'skill_id' => $skill_id,
                'classification_id' => $classification_id,
                'level_id' => $level_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($questions_attended > 0) ? intval(round(($correct_answers / $total_questions) * 100)) : 0,
                'winning_coin' => 0,
            ]);

            $insert['status'] = ($insert['percentage'] >= $quiz_config['min_winning_percentage']) ? 1 : 0;
            if ($insert['status'] == 1) {

                $insert['winning_coin'] = $quiz_config['winning_coin'];
                if ($quiz_config['winning_coin_type'] == 1) {

                    $is_played = $this->common->is_played_quiz(2, $user_id, $category_id, $skill_id, $classification_id, $level_id);
                    if ($is_played == 1) {
                        $insert['winning_coin'] = 0;
                    }
                }
            }

            if ($insert->save()) {

                if ($insert['winning_coin'] > 0) {
                    User::where('id', $user_id)->increment('wallet_coin', $insert['winning_coin']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_audio_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];
            $quiz_config = $this->common->Quiz_Configuration(3);

            $insert = new Audio_Quiz_Leaderboard([
                'user_id' => $user_id,
                'category_id' => $category_id,
                'skill_id' => $skill_id,
                'classification_id' => $classification_id,
                'level_id' => $level_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($questions_attended > 0) ? intval(round(($correct_answers / $total_questions) * 100)) : 0,
                'winning_coin' => 0,
            ]);

            $insert['status'] = ($insert['percentage'] >= $quiz_config['min_winning_percentage']) ? 1 : 0;
            if ($insert['status'] == 1) {

                $insert['winning_coin'] = $quiz_config['winning_coin'];
                if ($quiz_config['winning_coin_type'] == 1) {

                    $is_played = $this->common->is_played_quiz(3, $user_id, $category_id, $skill_id, $classification_id, $level_id);
                    if ($is_played == 1) {
                        $insert['winning_coin'] = 0;
                    }
                }
            }

            if ($insert->save()) {

                if ($insert['winning_coin'] > 0) {
                    User::where('id', $user_id)->increment('wallet_coin', $insert['winning_coin']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_video_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];
            $quiz_config = $this->common->Quiz_Configuration(4);

            $insert = new Video_Quiz_Leaderboard([
                'user_id' => $user_id,
                'category_id' => $category_id,
                'skill_id' => $skill_id,
                'classification_id' => $classification_id,
                'level_id' => $level_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($questions_attended > 0) ? intval(round(($correct_answers / $total_questions) * 100)) : 0,
                'winning_coin' => 0,
            ]);

            $insert['status'] = ($insert['percentage'] >= $quiz_config['min_winning_percentage']) ? 1 : 0;
            if ($insert['status'] == 1) {

                $insert['winning_coin'] = $quiz_config['winning_coin'];
                if ($quiz_config['winning_coin_type'] == 1) {

                    $is_played = $this->common->is_played_quiz(4, $user_id, $category_id, $skill_id, $classification_id, $level_id);
                    if ($is_played == 1) {
                        $insert['winning_coin'] = 0;
                    }
                }
            }

            if ($insert->save()) {

                if ($insert['winning_coin'] > 0) {
                    User::where('id', $user_id)->increment('wallet_coin', $insert['winning_coin']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_true_false_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];
            $quiz_config = $this->common->Quiz_Configuration(5);

            $insert = new True_False_Quiz_Leaderboard([
                'user_id' => $user_id,
                'category_id' => $category_id,
                'skill_id' => $skill_id,
                'classification_id' => $classification_id,
                'level_id' => $level_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($questions_attended > 0) ? intval(round(($correct_answers / $total_questions) * 100)) : 0,
                'winning_coin' => 0,
            ]);

            $insert['status'] = ($insert['percentage'] >= $quiz_config['min_winning_percentage']) ? 1 : 0;
            if ($insert['status'] == 1) {

                $insert['winning_coin'] = $quiz_config['winning_coin'];
                if ($quiz_config['winning_coin_type'] == 1) {

                    $is_played = $this->common->is_played_quiz(5, $user_id, $category_id, $skill_id, $classification_id, $level_id);
                    if ($is_played == 1) {
                        $insert['winning_coin'] = 0;
                    }
                }
            }

            if ($insert->save()) {

                if ($insert['winning_coin'] > 0) {
                    User::where('id', $user_id)->increment('wallet_coin', $insert['winning_coin']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_fear_factor_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'category_id' => 'required|numeric',
                'skill_id' => 'required|numeric',
                'classification_id' => 'required|numeric',
                'level_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $category_id = $request['category_id'];
            $skill_id = $request['skill_id'];
            $classification_id = $request['classification_id'];
            $level_id = $request['level_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];
            $quiz_config = $this->common->Quiz_Configuration(6);

            $insert = new Fear_Factor_Quiz_Leaderboard([
                'user_id' => $user_id,
                'category_id' => $category_id,
                'skill_id' => $skill_id,
                'classification_id' => $classification_id,
                'level_id' => $level_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($total_questions > 0) ? intval(round((max(0, $correct_answers - ($questions_attended - $correct_answers)) / $total_questions) * 100)) : 0,
                'winning_coin' => 0,
            ]);

            $insert['status'] = ($insert['percentage'] >= $quiz_config['min_winning_percentage']) ? 1 : 0;
            if ($insert['status'] == 1) {

                $insert['winning_coin'] = $quiz_config['winning_coin'];
                if ($quiz_config['winning_coin_type'] == 1) {

                    $is_played = $this->common->is_played_quiz(6, $user_id, $category_id, $skill_id, $classification_id, $level_id);
                    if ($is_played == 1) {
                        $insert['winning_coin'] = 0;
                    }
                }
            }

            if ($insert->save()) {

                if ($insert['winning_coin'] > 0) {
                    User::where('id', $user_id)->increment('wallet_coin', $insert['winning_coin']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_daily_quiz_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];
            $quiz_config = $this->common->Quiz_Configuration(9);

            $insert = new Daily_Quiz_Leaderboard([
                'user_id' => $user_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($questions_attended > 0) ? intval(round(($correct_answers / $total_questions) * 100)) : 0,
                'winning_coin' => 0,
            ]);

            $insert['status'] = ($insert['percentage'] >= $quiz_config['min_winning_percentage']) ? 1 : 0;
            if ($insert['status'] == 1) {
                $insert['winning_coin'] = $quiz_config['winning_coin'];
            }

            if ($insert->save()) {

                if ($insert['winning_coin'] > 0) {
                    User::where('id', $user_id)->increment('wallet_coin', $insert['winning_coin']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    // Ultimate Challenge
    public function get_live_ultimate_challenge(Request $request)
    {
        try {
            // Inactive 
            $this->common->Inactive_Challenge();

            $user_id = $request['user_id'] ?? 0;

            $data = Ultimate_Challenge::where('status', 1)->whereDate('start_date', '<=', date('Y-m-d'))->orderBy('end_date', 'asc')->get();
            if (count($data) > 0) {

                foreach ($data as $key => $value) {

                    $value['image'] = $this->common->getImage($this->folder_ultimate_challenge, $value['image']);
                    $value['is_played'] = Ultimate_Challenge_Leaderboard::where('user_id', $user_id)->where('ultimate_challenge_id', $value['id'])->exists() ? 1 : 0;
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_ultimate_challenge_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'ultimate_challenge_id' => 'required|numeric',
                'user_id' => 'required|numeric',
                'joining_coin' => 'required|numeric',
                'total_questions' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $ultimate_challenge_id = $request['ultimate_challenge_id'];
            $user_id = $request['user_id'];
            $joining_coin = $request['joining_coin'];
            $total_questions = $request['total_questions'];

            $data = Ultimate_Challenge_Question::where('status', 1)->where('ultimate_challenge_id', $ultimate_challenge_id)->inRandomOrder()->limit($total_questions)->get();
            if (count($data) > 0) {

                // Minus Coin
                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $joining_coin) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
                $user->decrement('wallet_coin', $joining_coin);

                $this->common->imageNameToUrl($data, 'image', $this->folder_ultimate_challenge);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_ultimate_challenge_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'ultimate_challenge_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $ultimate_challenge_id = $request['ultimate_challenge_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];

            $ultimate_challenge = Ultimate_Challenge::where('id', $ultimate_challenge_id)->first();
            if (!$ultimate_challenge) {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }

            $insert = new Ultimate_Challenge_Leaderboard([
                'user_id' => $user_id,
                'ultimate_challenge_id' => $ultimate_challenge_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($questions_attended > 0) ? intval(round(($correct_answers / $total_questions) * 100)) : 0,
                'winning_coin' => 0,
            ]);

            $insert['status'] = ($insert['percentage'] >= $ultimate_challenge['min_winning_percentage']) ? 1 : 0;
            if ($insert['status'] == 1) {
                $insert['winning_coin'] = $ultimate_challenge['winning_coin'];
            }

            if ($insert->save()) {

                if ($insert['winning_coin'] > 0) {
                    User::where('id', $user_id)->increment('wallet_coin', $insert['winning_coin']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    // Exam
    public function get_exam(Request $request)
    {
        try {

            $user_id = $request['user_id'] ?? 0;

            $data = Exam::where('status', 1)->latest()->get();
            if (count($data) > 0) {

                foreach ($data as $key => $value) {

                    $value['image'] = $this->common->getImage($this->folder_exam, $value['image']);
                    $value['is_played'] = Exam_Leaderboard::where('user_id', $user_id)->where('exam_id', $value['id'])->exists() ? 1 : 0;
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_exam_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'exam_id' => 'required|numeric',
                'user_id' => 'required|numeric',
                'entry_fee' => 'required|numeric',
                'total_questions' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $exam_id = $request['exam_id'];
            $user_id = $request['user_id'];
            $entry_fee = $request['entry_fee'];
            $total_questions = $request['total_questions'];

            $data = Exam_Question::where('status', 1)->where('exam_id', $exam_id)->inRandomOrder()->limit($total_questions)->get();
            if (count($data) > 0) {

                // Minus Coin
                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $entry_fee) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
                $user->decrement('wallet_coin', $entry_fee);

                $this->common->imageNameToUrl($data, 'image', $this->folder_exam);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_exam_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'exam_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $exam_id = $request['exam_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];

            $exam = Exam::where('id', $exam_id)->first();
            if (!$exam) {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }

            $insert = new Exam_Leaderboard([
                'user_id' => $user_id,
                'exam_id' => $exam_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($questions_attended > 0) ? intval(round(($correct_answers / $total_questions) * 100)) : 0,
                'winning_coin' => 0,
            ]);

            $insert['status'] = ($insert['percentage'] >= $exam['min_winning_percentage']) ? 1 : 0;
            if ($insert['status'] == 1) {
                $insert['winning_coin'] = $exam['winning_coin'];
            }

            if ($insert->save()) {

                if ($insert['winning_coin'] > 0) {
                    User::where('id', $user_id)->increment('wallet_coin', $insert['winning_coin']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_user_exam(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];

            $data = Exam_Leaderboard::where('user_id', $user_id)->with('exam')->latest()->get();
            if (count($data) > 0) {

                foreach ($data as $key => $value) {

                    $value['name'] = "";
                    $value['entry_fee'] = 0;
                    $value['quiz_duration'] = 0;
                    if ($value['exam'] != null) {

                        $value['name'] = $value['exam']['name'];
                        $value['entry_fee'] = $value['exam']['entry_fee'];
                        $value['quiz_duration'] = $value['exam']['quiz_duration'];
                    }
                    unset($value['exam']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    // Contest
    public function get_contest(Request $request) // type : 1- Upcoming, 2- Live, 3- Ended
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'type' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];

            $data = [];
            $currentDateTime = date('Y-m-d');
            if ($request['type'] == 1) {

                $data = Contest::where('start_date', '>', $currentDateTime)->orderBy('start_date', 'asc')->get();
            } elseif ($request['type'] == 2) {

                $contest_ids = Contest_Transaction::where('user_id', $user_id)->pluck('contest_id')->toArray();
                $data = Contest::whereIn('id', $contest_ids)->where('start_date', '<=', $currentDateTime)->where('end_date', '>=', $currentDateTime)->orderBy('end_date', 'asc')->get();
            } elseif ($request['type'] == 3) {

                $contest_ids = Contest_Transaction::where('user_id', $user_id)->pluck('contest_id')->toArray();
                $data = Contest::whereIn('id', $contest_ids)->where('end_date', '<', $currentDateTime)->orderBy('end_date', 'desc')->get();
            }

            if (count($data) > 0) {

                foreach ($data as $key => $value) {

                    $value['image'] = $this->common->getImage($this->folder_contest, $value['image']);

                    $value['total_participants_user'] = Contest_Transaction::where('contest_id', $value['id'])->count();
                    $value['is_buy'] = Contest_Transaction::where('user_id', $user_id)->where('contest_id', $value['id'])->exists() ? 1 : 0;
                    $value['is_played'] = Contest_Leaderboard::where('user_id', $user_id)->where('contest_id', $value['id'])->exists() ? 1 : 0;
                    $value['question_json'] = "";
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
            return $return;
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function join_contest(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'contest_id' => 'required|numeric',
                'coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $contest_id = $request['contest_id'];
            $coin = $request['coin'];

            $contest = Contest::where('id', $contest_id)->first();
            $JoinUser = Contest_Transaction::where('contest_id', $contest_id)->count();
            if ($JoinUser < $contest['max_participants']) {

                $user = User::find($user_id);
                if (!$user || $user['wallet_coin'] < $coin) {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }

                $insert = new Contest_Transaction();
                $insert['user_id'] = $user_id;
                $insert['contest_id'] = $contest_id;
                $insert['coin'] = $coin;

                if ($insert->save()) {

                    $user->decrement('wallet_coin', $coin);
                    return $this->common->API_Response(200, __('api_msg.contest_joined'), []);
                } else {
                    return $this->common->API_Response(400, __('api_msg.data_not_save'));
                }
            } else {
                return $this->common->API_Response(400, __('api_msg.contest_is_full'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_contest_question(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'contest_id' => 'required|numeric',
                'user_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $contest_id = $request['contest_id'];
            $user_id = $request['user_id'];
            $total_questions = $request['total_questions'];

            $data = Contest_Question::where('status', 1)->where('contest_id', $contest_id)->inRandomOrder()->limit($total_questions)->get();
            if (count($data) > 0) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_contest);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function save_contest_question_report(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'contest_id' => 'required|numeric',
                'total_questions' => 'required|numeric',
                'questions_attended' => 'required|numeric',
                'correct_answers' => 'required|numeric',
                'question_json' => 'required',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $contest_id = $request['contest_id'];
            $total_questions = $request['total_questions'];
            $questions_attended = $request['questions_attended'];
            $correct_answers = $request['correct_answers'];
            $question_json = $request['question_json'];

            $contest = Contest::where('id', $contest_id)->first();
            if (!$contest) {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }

            $insert = new Contest_Leaderboard([
                'contest_id' => $contest_id,
                'user_id' => $user_id,
                'total_questions' => $total_questions,
                'questions_attended' => $questions_attended,
                'correct_answers' => $correct_answers,
                'percentage' => ($questions_attended > 0) ? intval(round(($correct_answers / $total_questions) * 100)) : 0,
                'question_json' => $question_json,
                'rank' => 0,
                'winning_coin' => 0,
                'status' => 1,
            ]);

            if ($insert->save()) {
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $insert);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_contest_leaderboard(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'contest_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $contest_id = $request['contest_id'];

            $winner_check = Contest_Leaderboard::where('contest_id', $contest_id)->where('rank', 0)->first();
            if ($winner_check) {
                return $this->common->API_Response(400, __('api_msg.no_winner_yet'));
            }

            $leaderboard['status'] = 200;
            $leaderboard['message'] = __('api_msg.data_retrieved');
            $leaderboard['result'] = [];
            $leaderboard['user'] = [];

            $data = Contest_Leaderboard::where('contest_id', $contest_id)->with('user')->orderBy('rank', 'asc')->get();
            for ($i = 0; $i < count($data); $i++) {

                if ($data[$i]['user'] != null) {

                    $this->common->userImage([$data[$i]['user']]);

                    $users['id'] = $data[$i]['id'];
                    $users['rank'] = $data[$i]['rank'];
                    $users['contest_id'] = $data[$i]['contest_id'];
                    $users['user_id'] = $data[$i]['user_id'];
                    $users['winning_coin'] = $data[$i]['winning_coin'];
                    $users['user_name'] = $data[$i]['user']['user_name'];
                    $users['full_name'] = $data[$i]['user']['full_name'];
                    $users['image_type'] = $data[$i]['user']['image_type'];
                    $users['image'] = $data[$i]['user']['image'];
                    $users['percentage'] = $data[$i]['percentage'];
                    $leaderboard['result'][] = $users;
                }
            }

            $data_user = Contest_Leaderboard::where('contest_id', $contest_id)->where('user_id', $user_id)->with('user')->orderBy('rank', 'asc')->first();
            if ($data_user && $data_user['user'] != null) {

                $this->common->userImage([$data_user['user']]);

                $user['id'] = $data_user['id'];
                $user['rank'] = $data_user['rank'];
                $user['contest_id'] = $data_user['contest_id'];
                $user['user_id'] = $data_user['user_id'];
                $user['winning_coin'] = $data_user['winning_coin'];
                $user['user_name'] = $data_user['user']['user_name'];
                $user['full_name'] = $data_user['user']['full_name'];
                $user['image_type'] = $data_user['user']['image_type'];
                $user['image'] = $data_user['user']['image'];
                $user['percentage'] = $data_user['percentage'];
                $leaderboard['user'][] = $user;
            }
            return $leaderboard;
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_review_question_by_contest_id(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'contest_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];
            $contest_id = $request['contest_id'];

            $data = Contest_Leaderboard::where('user_id', $user_id)->where('contest_id', $contest_id)->where('rank', '!=', 0)->first();
            if ($data) {

                $Uquestion = [];
                $Json = json_decode($data['question_json'], true) ?? [];
                foreach ($Json as $key => $value) {

                    $question = Contest_Question::where('id', $value['id'])->first();
                    if ($question) {

                        $question['image'] = $this->common->getImage($this->folder_contest, $question['image']);
                        $question['user_answer'] = $value['user_answer'];
                        $Uquestion[] = $question;
                    }
                }
                $data['question_list'] = $Uquestion;

                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function add_transaction(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'package_id' => 'required|numeric',
                'price' => 'required',
                'coin' => 'required|numeric',
                'transaction_id' => 'required',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = new Transaction();
            $data['user_id'] = $request['user_id'];
            $data['package_id'] = $request['package_id'];
            $data['transaction_id'] = $request['transaction_id'];
            $data['price'] = $request['price'];
            $data['coin'] = $request['coin'];
            $data['description'] = $request['description'] ?? "";
            $data['status'] = 1;
            if ($data->save()) {

                User::where('id', $data['user_id'])->increment('wallet_coin', $data['coin']);

                // Send Mail (Type = 1- Register Mail, 2 Transaction Mail)
                // $user = Users::where('id', $request->user_id)->first();
                // if (isset($user) && $user != null) {
                //     $this->common->Send_Mail(2, $user->email);
                // }

                return $this->common->API_Response(200, __('api_msg.data_saved'));
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_transaction(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = Transaction::where('user_id', $request['user_id'])->with('package')->latest()->get();
            if (count($data) > 0) {

                for ($i = 0; $i < count($data); $i++) {

                    $data[$i]['packge_name'] = "";
                    if ($data[$i]['package'] != null) {
                        $data[$i]['packge_name'] = $data[$i]['package']['name'];
                    }
                    unset($data[$i]['package']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(200, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function reward_setting()
    {
        try {

            $data = Reward_Setting::get();
            if ($data) {
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function reward_transaction(Request $request) // Reward Type : 1- Spin Wheel, 2- Daily Reward, 3- Ads Free Watch
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'reward_type' => 'required|numeric',
                'coin' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $insert = new Reward_Transaction();
            $insert['user_id'] = $request['user_id'];
            $insert['reward_type'] = $request['reward_type'];
            $insert['coin'] = $request['coin'];
            if ($insert->save()) {

                User::where('id', $request['user_id'])->increment('wallet_coin', $request['coin']);

                return $this->common->API_Response(200, __('api_msg.data_saved'));
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_reward_transaction(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = Reward_Transaction::where('user_id', $request['user_id'])->latest()->get();
            if (count($data) > 0) {
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function withdrawal_list(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = Withdrawal_Request::where('user_id', $request['user_id'])->orderBy('status', 'asc')->get();
            if (count($data) > 0) {
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function withdrawal_request(Request $request)
    {
        try {
            $setting_data = Setting_Data();
            $min_withdrawal_coin = $setting_data['min_withdrawal_coin'];

            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'payment_detail' => 'required',
                'payment_type' => 'required',
                'coin' => 'required|numeric|min:' . $min_withdrawal_coin,
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = User::where('id', $request['user_id'])->first();
            if ($data) {

                if ($data['wallet_coin'] >= $min_withdrawal_coin) {

                    $insert = new Withdrawal_Request();
                    $insert['user_id'] = $request['user_id'];
                    $insert['coin'] = $request['coin'];
                    $insert['total_amount'] = round(($request['coin'] * $setting_data['coin_per_amount']) / $setting_data['earning_per_coin']);
                    $insert['payment_type'] = $request['payment_type'];
                    $insert['payment_detail'] = $request['payment_detail'];
                    $insert['status'] = 0;
                    $insert->save();

                    $data['wallet_coin'] = $data['wallet_coin'] - $request['coin'];
                    $data->save();

                    return $this->common->API_Response(200, __('api_msg.data_saved'), []);
                } else {
                    $msg['status'] = 201;
                    $msg['message'] = "Minimum {$min_withdrawal_coin} Points Required.";
                    return $msg;
                }
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_coin_leaderboard(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $user_id = $request['user_id'];

            $return = [
                'status' => 200,
                'message' => __('api_msg.data_retrieved'),
                'result' => [],
                'user' => [],
            ];

            $data = User::where('status', 1)->where('wallet_coin', '>', 0)->orderBy('wallet_coin', 'desc')->get();

            $this->common->userImage($data);

            $rank = 1;
            foreach ($data as $user) {
                $user['rank'] = $rank;

                if ($rank <= 10) {
                    $return['result'][] = $user;
                }

                if ($user['id'] == $user_id) {
                    $return['user'] = array($user);
                }
                $rank++;
            }

            return $return;
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_refer_earn_history(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'user_id' => 'required|numeric',
        ]);
        if ($validation->fails()) {
            return $this->common->API_Response(400, $validation->errors()->first());
        }

        $data = Refer_Earn::where('parent_user_id', $request['user_id'])->with('child_user')->latest()->get();
        if (count($data) > 0) {

            foreach ($data as $key => $value) {

                $value['user_name'] = "";
                $value['full_name'] = "";
                $value['email'] = "";
                $value['image'] = asset('assets/imgs/default.png');
                if ($value['child_user'] != null) {

                    $value['user_name'] = $value['child_user']['user_name'];
                    $value['full_name'] = $value['child_user']['full_name'];
                    $value['email'] = $value['child_user']['email'];
                    $this->common->userImage(array($value['child_user']));
                    $value['image'] = $value['child_user']['image'];
                }
                unset($value['child_user']);
            }
            return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
        } else {
            return $this->common->API_Response(400, __('api_msg.data_not_found'));
        }
    }
    public function get_product()
    {
        try {

            $data = Product::where('status', 1)->orderBy('coin', 'asc')->latest()->get();
            if ($data) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_product);
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function get_user_product(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = Product_Transaction::where('user_id', $request['user_id'])->with('product')->latest()->get();
            if (count($data) > 0) {

                for ($i = 0; $i < count($data); $i++) {

                    $data[$i]['product_name'] = "";
                    $data[$i]['product_image'] = asset('assets/imgs/no_img.png');
                    if ($data[$i]['product'] != null) {
                        $data[$i]['product_name'] = $data[$i]['product']['name'];
                        $data[$i]['product_image'] = $this->common->getImage($this->folder_product, $data[$i]['product']['image']);
                    }
                    unset($data[$i]['product']);
                }
                return $this->common->API_Response(200, __('api_msg.data_retrieved'), $data);
            } else {
                return $this->common->API_Response(200, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function add_product_transaction(Request $request)
    {
        try {
            $validation = Validator::make($request->all(), [
                'user_id' => 'required|numeric',
                'product_id' => 'required|numeric',
                'coin' => 'required|numeric',
                'address' => 'required',
            ]);
            if ($validation->fails()) {
                return $this->common->API_Response(400, $validation->errors()->first());
            }

            $data = User::where('id', $request['user_id'])->first();
            if ($data) {

                if ($data['wallet_coin'] >= $request['coin']) {

                    $insert = new Product_Transaction();
                    $insert['user_id'] = $request['user_id'];
                    $insert['product_id'] = $request['product_id'];
                    $insert['coin'] = $request['coin'];
                    $insert['address'] = $request['address'];
                    $insert['status'] = 0;
                    $insert->save();

                    $data['wallet_coin'] = $data['wallet_coin'] - $request['coin'];
                    $data->save();

                    return $this->common->API_Response(200, __('api_msg.data_saved'), []);
                } else {
                    return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
                }
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }

    // 1 vs 1 Battles
    // public function create_one_vs_one_battle(Request $request)
    // {
    //     try {
    //         $validation = Validator::make($request->all(), [
    //             'c_user_id' => 'required|numeric',
    //             'name' => 'required|max:30',
    //             'total_questions' => 'required|numeric|min:1|max:20',
    //             'joining_coin' => 'required|numeric|min:1',
    //         ]);
    //         if ($validation->fails()) {
    //             return $this->common->API_Response(400, $validation->errors()->first());
    //         }

    //         $c_user_id = $request['c_user_id'];
    //         $name = $request['name'];
    //         $total_questions = $request['total_questions'];
    //         $joining_coin = $request['joining_coin'];

    //         $user = User::find($c_user_id);
    //         if (!$user || $user['wallet_coin'] < $joining_coin) {
    //             return $this->common->API_Response(400, __('api_msg.insufficient_balance'));
    //         }

    //         $insert = new One_vs_One_Battles();
    //         $insert['room_code'] = $this->common->create_room_code(6);
    //         $insert['name'] = $name;
    //         $insert['total_questions'] = $total_questions;
    //         $question = Battles_Question::where('status', 1)->inRandomOrder()->limit($total_questions)->get();
    //         $insert['question_ids'] = $question->pluck('id')->implode(', ');
    //         $insert['joining_coin'] = $joining_coin;
    //         $quiz_config = $this->common->Quiz_Configuration(10);
    //         $total_pool = $joining_coin * 2;
    //         $commission_percent = $quiz_config['battles_commission'] ?? 0;
    //         $commission_amount = ($total_pool * $commission_percent) / 100;
    //         $insert['winning_coin'] = intval(round($total_pool - $commission_amount));
    //         $insert['is_full'] = 0;
    //         $insert['c_user_id'] = $c_user_id;
    //         $insert['c_questions_attended'] = 0;
    //         $insert['c_correct_answers'] = 0;
    //         $insert['c_percentage'] = 0;
    //         $insert['j_user_id'] = 0;
    //         $insert['j_questions_attended'] = 0;
    //         $insert['j_correct_answers'] = 0;
    //         $insert['j_percentage'] = 0;
    //         $insert['w_user_id'] = 0;
    //         $insert['l_user_id'] = 0;
    //         $insert['status'] = 2;
    //         if ($insert->save()) {
    //             return $this->common->API_Response(200, __('api_msg.battle_created'), $insert);
    //         } else {
    //             return $this->common->API_Response(400, __('api_msg.data_not_save'));
    //         }
    //     } catch (Exception $e) {
    //         return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
    //     }
    // }
    // public function get_one_vs_one_battle_question(Request $request)
    // {
    //     try {
    //         $validation = Validator::make($request->all(), [
    //             'room_code' => 'required',
    //         ]);
    //         if ($validation->fails()) {
    //             return $this->common->API_Response(400, $validation->errors()->first());
    //         }

    //         $room_code = $request['room_code'];

    //         $battle = One_vs_One_Battles::where('room_code', $room_code)->first();

    //         if ($ChackRoomId) {

    //             if ($ChackRoomId->is_full != 0) {

    //                 if ($ChackRoomId->end_date >= date("Y-m-d H:i:s")) {

    //                     if ($ChackRoomId->start_date <= date("Y-m-d H:i:s")) {

    //                         $QIds = $ChackRoomId->question_ids;
    //                         $TQCount = count(explode(", ", $QIds));
    //                         $id = explode(", ", $QIds);
    //                         $Question_Result = array();

    //                         for ($i = 0; $i < $TQCount; $i++) {

    //                             $Question = Question::where('id', $id[$i])->first();

    //                             $this->common->imageNameToUrl(array($Question), 'image', $this->folder_question);
    //                             $Question_Result[] = $Question;
    //                         }

    //                         return $this->common->API_Response(200,  __('api_msg.get_record_successfully'), $Question_Result);
    //                     } else {

    //                         return $this->common->API_Response(400,  __('api_msg.Wait, Challenge is not Started.'));
    //                     }
    //                 } else {

    //                     return $this->common->API_Response(400,  __('api_msg.Challenge is Over.'));
    //                 }
    //             } else {
    //                 return $this->common->API_Response(400,  __('api_msg.Not Join Any Other User In This Challenge.'));
    //             }
    //         } else {

    //             return $this->common->API_Response(400,  __('api_msg.Please enter right room id.'));
    //         }
    //     } catch (Exception $e) {
    //         return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
    //     }
    // }
}
